#!/bin/bash
if [ $# -eq 0 ]; then
    echo "Usage : vitasendfile.sh $toBeSentFile $VITAIP $destinationAdress OR $CMakeLists.txt (used to extract destination (eg: ux0:/app/VSDK00006/)"
    exit 1
fi

if [[ -f $3 ]]; then #  $3 is a file => assume it's a CMakeLists.txt because I am lazy and parse it to determine VITA_TITLEID
	echo "File detected as third parameter => Sending to eboot.bin to app folder"
        VITA_TITLEID=`awk -F \" '/set\(VITA_TITLEID /{print $2}' $3`
        curl --ftp-method nocwd -T $1.self ftp://$2:1337/ux0:/app/$VITA_TITLEID/eboot.bin;
	exit 0;
fi

curl --ftp-method nocwd -T $1.vpk ftp://$2:1337/$3;
